<?php
while(ob_get_level())
ob_end_clean();

/**
تابع کمکی برای تشخیص پارسی یا انگلیسی بودن
*/
 function TextIsPersian($str){
        return preg_match('/[\x{0600}-\x{06FF}]/u', $str);
};

/**
تابع کمکی تبدیل متن به حالت ایمن در URL
*/
 function B64Uec($str){
        return urlencode(base64_encode($str));
};



/**
تابع اصلی تبدیل
*/
function AvatarWebp(
     $text,
     $size = 128,
     $bgColorHex = '',
     $color = ""
   
) {

$bgColorHex = strlen($bgColorHex)>3 ? $bgColorHex : '#5A0067';
$color =strlen($color)>3 ? $color : '#F6AA09';

$sep = " ";

$faFontPath = 'fonts/IranSans-B.ttf' ;
$enFontPath =  'fonts/Inter-B.ttf';
 
$text = urldecode($text);
//$text = base64_decode($text);

$first = "";
$end = "";

$exp = explode(" ",$text);

$first = $exp[0];
$end = $exp[1] ?? "";

$text = "";


if(TextIsPersian($first) || TextIsPersian($end) ){
$first = mb_substr($first,0,1);
$end = mb_substr($end,0,1);


}else{
$first =substr($first,0,1);
$end =substr($end,0,1);
$first = ucfirst($first );
$end =ucfirst($end);

}


if(TextIsPersian($first) || TextIsPersian($end) ){

$text = ($first && $end    ?   $end . $sep .$first     :   ($first && !$end   ?  $first : '?' )  );
}else{
$text = $first.($end ?  $sep .$end : "");

}



$text = "  ".$text."  ";


    // --- Helpers ---
    $hexToRgb = function($hex) {
        $hex = ltrim($hex, '#');
        if(strlen($hex) === 3){
            $hex = $hex[0].$hex[0].$hex[1].$hex[1].$hex[2].$hex[2];
        }
        return [
            hexdec(substr($hex,0,2)),
            hexdec(substr($hex,2,2)),
            hexdec(substr($hex,4,2))
        ];
    };

    // luminance check → جلوگیری از بکگراند روشن
    $isTooLight = function($r,$g,$b){
        // perceived luminance
        $l = (0.299*$r + 0.587*$g + 0.114*$b);
        return $l > 160; // اگر خیلی روشن باشد
    };

    // detect persian
    $isPersian = function($str){
        return preg_match('/[\x{0600}-\x{06FF}]/u', $str);
    };

    // --- Color ---
    list($r,$g,$b) = $hexToRgb($bgColorHex);

    if($isTooLight($r,$g,$b)){
        // اگر رنگ خیلی روشن بود → خودکار تیره‌ترش می‌کنیم
        $r = intval($r * 0.4);
        $g = intval($g * 0.4);
        $b = intval($b * 0.4);
    }

    // --- Image Create ---
    $img = imagecreatetruecolor($size, $size);

    imagealphablending($img, true);
    imagesavealpha($img, true);

    $bg = imagecolorallocate($img, $r, $g, $b);
      list($r,$g,$b) = $hexToRgb($color);
    $white = imagecolorallocate($img, $r,$g,$b);

    imagefill($img, 0, 0, $bg);

    // --- Font Select ---
    $font = TextIsPersian($first) ? $faFontPath : $enFontPath;

    // --- Font Size Auto ---
    // حدودی برای متن کوتاه
    $fontSize = $size * 0.5;

    // کاهش سایز اگر متن بیشتر از 2 کاراکتر
    if(mb_strlen($text) >= 3) $fontSize = $size * 0.38;
    if(mb_strlen($text) >= 5) $fontSize = $size * 0.28;

    // --- Center Text ---
    $box = imagettfbbox($fontSize, 0, $font, $text);

    $textWidth  = abs($box[4] - $box[0]);
    $textHeight = abs($box[5] - $box[1]);

    $x = ($size - $textWidth) / 2;
    $y = ($size + $textHeight) / 2;

    imagettftext($img, $fontSize, 0, $x, $y, $white, $font, $text);

    // --- Output WebP to Memory ---

    ob_start();
    imagewebp($img, null, 90);
    $data = ob_get_clean();

    imagedestroy($img);

    return $data;
}




/**

شروع کدهای خواندن درخواست متن شما و تبدیل به عکس


*/


$text = $_GET['text'] ?? "";

$size = intval($_GET['size']??64);

$color = $_GET['color'] ?? '0';

$bgcolor= $_GET['bgcolor'] ?? '0';


$data = AvatarWebp($text,$size,'#'.$bgcolor,'#'.$color);


header('Content-Type: image/webp');

// کش مرورگر
header("Cache-Control: public, max-age=".(3600*24*30).", immutable");

echo $data;

exit;


?>


